# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from datetime import timedelta

from django.conf import settings

from common.workflow.sleep import WaitAction, WaitTillStatuses
from travel.rasp.train_api.train_purchase.workflow.ticket_refund.create_refund_payment import (
    CreateRefundPaymentEvents, CreateRefundPayment
)
from travel.rasp.train_api.train_purchase.workflow.ticket_refund.refund_order import RefundOrder, RefundOrderEvents
from travel.rasp.train_api.train_purchase.workflow.ticket_refund.send_refund_email import (
    SendRefundEmail, SendRefundEmailEvents
)
from travel.rasp.train_api.train_purchase.workflow.ticket_refund.unset_is_active import UnsetIsActive, UnsetIsActiveRefundEvents
from travel.rasp.train_api.train_purchase.workflow.user_events import RefundUserEvents

TICKET_REFUND_PROCESS = 'ticket_refund_process'

REFUND_PAYMENT_SLEEP_DURATION = timedelta(seconds=20)


class RefundState(object):
    REFUNDING = 'refunding'
    CREATE_REFUND_PAYMENT = 'create_refund_payment'
    WAITING_REFUND_PAYMENT = 'waiting_refund_payment'
    COMPLETING_REFUND = 'completing_refund'
    UNSET_IS_ACTIVE = 'unset_is_active'
    DONE = 'done'


ticket_refund_scheme = {
    'initial_state': RefundState.REFUNDING,
    'states': {
        RefundState.REFUNDING: {
            'do': RefundOrder,
            'transitions': {
                RefundOrderEvents.DONE: RefundState.CREATE_REFUND_PAYMENT,
                RefundOrderEvents.OFFICE_REFUND: RefundState.CREATE_REFUND_PAYMENT,
                RefundOrderEvents.NO_ACTIVE_CONTRACT: RefundState.UNSET_IS_ACTIVE,
                RefundOrderEvents.FAILED: RefundState.UNSET_IS_ACTIVE
            },
        },
        RefundState.CREATE_REFUND_PAYMENT: {
            'do': CreateRefundPayment,
            'transitions': {
                CreateRefundPaymentEvents.CREATED: RefundState.WAITING_REFUND_PAYMENT,
            },
        },
        RefundState.WAITING_REFUND_PAYMENT: {
            'do': {'action': WaitAction, 'args': (REFUND_PAYMENT_SLEEP_DURATION,)},
            'transitions': {
                WaitTillStatuses.OK: RefundState.COMPLETING_REFUND,
            },
        },
        RefundState.COMPLETING_REFUND: {
            'do': SendRefundEmail,
            'transitions': {
                SendRefundEmailEvents.DONE: RefundState.UNSET_IS_ACTIVE,
            },
        },
        RefundState.UNSET_IS_ACTIVE: {
            'do': UnsetIsActive,
            'transitions': {
                UnsetIsActiveRefundEvents.DONE: RefundState.DONE,
            },
        },
        RefundState.DONE: {
            'transitions': {
                RefundUserEvents.CREATE_ANOTHER_REFUND_PAYMENT: RefundState.CREATE_REFUND_PAYMENT,
            },
        },
    },
    'lock_alive_time': settings.WORKFLOW_LOCK_ALIVE_TIME,
    'lock_update_interval': settings.WORKFLOW_LOCK_UPDATE_INTERVAL_SECONDS
}
