# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.library.python.common23.date.environment import now_utc
from common.workflow.process import StateAction
from travel.rasp.train_api.train_purchase.core.models import RefundPaymentStatus, RefundPayment
from travel.rasp.train_api.train_purchase.utils.order import send_event_to_payment
from travel.rasp.train_api.train_purchase.workflow.user_events import PaymentUserEvents


class CreateRefundPaymentEvents(object):
    CREATED = 'created'


class CreateRefundPayment(StateAction):
    def do(self, _data, *_args, **_kwargs):
        refund = self.document
        payment = refund.order.current_billing_payment
        paid_insurance_ids = set(p.insurance.operation_id for p in refund.order.passengers
                                 if p.insurance and p.insurance.operation_id and p.insurance.trust_order_id)
        refund_insurance_ids = list(set(refund.insurance_ids) & paid_insurance_ids)
        refund_payment = RefundPayment.objects.create(
            order_uid=refund.order_uid,
            purchase_token=payment.purchase_token,
            refund_uuid=refund.uuid,
            refund_payment_status=RefundPaymentStatus.NEW,
            refund_created_at=now_utc(),
            refund_blank_ids=refund.blank_ids,
            refund_insurance_ids=refund_insurance_ids,
            user_info=refund.user_info,
        )
        send_event_to_payment(payment, PaymentUserEvents.REFUND_PAYMENT, params=refund_payment.id)
        return CreateRefundPaymentEvents.CREATED
