# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from common.workflow.process import StateAction
from travel.rasp.train_api.train_purchase.core.models import RefundStatus
from travel.rasp.train_api.train_purchase.utils.refund_email import send_refund_email

log = logging.getLogger(__name__)


class SendRefundEmailEvents(object):
    DONE = 'done'


class SendRefundEmail(StateAction):
    def do(self, _data):
        update_spec = {'set__status': RefundStatus.DONE}

        refund = self.document
        if refund.email_is_sent:
            log.info('Письмо пользователю уже отправленно')
            return SendRefundEmailEvents.DONE, update_spec

        try:
            send_refund_email(refund)
            update_spec['set__email_is_sent'] = True
        except Exception:
            log.exception('Не получилось отправить письмо о завершении возврата')
            raise
        return SendRefundEmailEvents.DONE, update_spec
