# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from apispec.ext.marshmallow import MarshmallowPlugin
from django.conf import settings
from django.conf.urls import include, url
from django.conf.urls.i18n import i18n_patterns
from django.conf.urls.static import static

from common.dev_tools.swagger import build_spec, get_swagger_view
from travel.rasp.train_api.popular_directions.views import train_popular_directions
from travel.rasp.train_api.search.views import train_segment
from travel.rasp.train_api.tariffs.train.views import (
    train_tariffs, train_tariffs_earliest_routed_date, min_tariffs, min_tariffs_short
)
from travel.rasp.train_api.train_purchase import views_async
from travel.rasp.train_api.train_purchase.backoffice import urls as backoffice_urls
from travel.rasp.train_api.train_purchase.views import orders_router, get_active_partners, user_orders, takeout_orders
from travel.rasp.train_api.train_purchase.views.travel import order_auth_details, calculate_tickets_fee
from travel.rasp.train_api.train_purchase.views.cpa.views import (
    orders_for_cpa_collector, orders_with_refunds_for_cpa_collector
)
from travel.rasp.train_api.train_purchase.views.insurance import orders_insurance_router

purchase_api_urlpatterns = [
    url(r'^active-partners/$', get_active_partners),
    url(r'^user-orders/$', user_orders),
    url(r'^download-blank/(?P<uid>.+)/$', views_async.download_blank),
    url(r'^calculate-refund-amount/(?P<uid>.+)/$', views_async.calculate_refund_amount),
    url(r'^update-tickets-status/(?P<uid>.+)/$', views_async.update_tickets_status),
    url(r'^change-registration-status/(?P<uid>.+)/$', views_async.change_registration_status),
    url(r'^ufs-train-details/$', views_async.train_details_view),
    url(r'^train-details/$', views_async.train_details_view),
    url(r'^partner-schedule/$', views_async.schedule),
    url(r'^order-tickets/$', views_async.order_tickets),
    url(r'^segments/train-tariffs/$', train_tariffs, name='train_tariffs'),
    url(r'^segments/train-tariffs/earliest_date/$', train_tariffs_earliest_routed_date),
    url(r'^segments/train-tariffs/poll/$', train_tariffs, {'poll': True}, name='train_tariffs_poll'),
    url(r'^segments/min-tariffs/$', min_tariffs),
    url(r'^segments/min-tariffs-short/$', min_tariffs_short),
    url(r'^train-popular-directions/$', train_popular_directions),
    url(r'^search/train-segment/$', train_segment),
    url(r'^takeout-orders/$', takeout_orders),
    url(r'^travel/order-auth-details/$', order_auth_details, name='order_auth_details'),
    url(r'^cpa/orders/$', orders_for_cpa_collector, name='cpa_orders'),
    url(r'^cpa/orders-with-refunds/$', orders_with_refunds_for_cpa_collector, name='cpa_orders_with_refunds'),
    url(r'^travel/calculate-tickets-fee/$', calculate_tickets_fee),
    url(r'^log-bandit/$', views_async.log_bandit),

    # for
    url(r'^internal/train-details/$', views_async.internal_train_details_view),
] + orders_router.urls + orders_insurance_router.urls

urlpatterns = i18n_patterns(
    url(r'^train-purchase-backoffice/', include(backoffice_urls)),
    url(r'^api/', include(purchase_api_urlpatterns)),
)

backoffice_spec = build_spec(
    {
        'title': 'Backoffice API',
        'version': '1.0.0',
        'info': {'description': 'АПИ для бэкофиса'},
        'plugins': [MarshmallowPlugin()],
        'basePath': '/ru/train-purchase-backoffice/',
    },
    urlpatterns=backoffice_urls.urlpatterns,
    schema_modules=[
        'travel.rasp.train_api.serialization.schema_bases',
        'travel.rasp.train_api.serialization.segment_station',
        'travel.rasp.train_api.serialization.segment',
        'travel.rasp.train_api.train_purchase.backoffice.serialization',
        'travel.rasp.train_api.train_purchase.backoffice.orders.serialization',
        'travel.rasp.train_api.train_purchase.backoffice.support.views',
        'travel.rasp.train_api.train_purchase.backoffice.trust_info.serialization',
        'travel.rasp.train_api.train_purchase.serialization',
    ]
)
train_purchase_spec = build_spec(
    {
        'title': 'Train purchase API',
        'version': '1.0.0',
        'info': {'description': 'АПИ покупки билетов'},
        'plugins': [MarshmallowPlugin()],
        'basePath': '/ru/api/',
    },
    urlpatterns=purchase_api_urlpatterns,
    schema_modules=[
        'travel.rasp.train_api.popular_directions.serialization',
        'travel.rasp.train_api.search.serialization',
        'travel.rasp.train_api.serialization.schema_bases',
        'travel.rasp.train_api.serialization.segment_station',
        'travel.rasp.train_api.serialization.segment',
        'travel.rasp.train_api.tariffs.serialization',
        'travel.rasp.train_api.tariffs.train.base.serialization',
        'travel.rasp.train_api.train_partners.base.serialization',
        'travel.rasp.train_api.train_partners.base.train_details.serialization',
        'travel.rasp.train_api.train_purchase.serialization',
        'travel.rasp.train_api.train_purchase.views.serialization',
    ]
)
urlpatterns += [
    url(r'^schema/backoffice', get_swagger_view(backoffice_spec)),
    url(r'^schema/train-purchase-api', get_swagger_view(train_purchase_spec)),
]


if settings.DEBUG:
    import debug_toolbar
    urlpatterns += [url(r'^__debug__/', include(debug_toolbar.urls))]
    urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
