# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import factory

from common.utils.date import timedelta2minutes, MSK_TZ


class WizardDirectionSegmentTrainBrandFactory(factory.DictFactory):
    is_deluxe = True
    id = 193
    is_high_speed = False
    title = 'Арктика'
    short_title = 'фирменный «Арктика»'


class WizardDirectionSegmentTrainFactory(factory.DictFactory):
    is_suburban = False
    has_dynamic_pricing = True
    title = 'Москва — Мурманск'
    display_number = '016А'
    two_storey = False
    number = '016А'
    coach_owners = ['ФПК']
    thread_type = 'basic'
    brand = factory.SubFactory(WizardDirectionSegmentTrainBrandFactory)
    first_country_code = 'RU'
    last_country_code = 'UA'


class WizardDirectionSegmentEventSettlementFactory(factory.DictFactory):
    key = 'c213'
    title = 'Москва'


class WizardDirectionSegmentEventStationFactory(factory.DictFactory):
    key = 's9602499'
    title = 'Станция'


class WizardDirectionSegmentEventDTFactory(factory.DictFactory):
    timezone = 'Europe/Moscow'
    value = '2019-02-16T00:41:00'


class WizardDirectionSegmentEventFactory(factory.DictFactory):
    settlement = factory.SubFactory(WizardDirectionSegmentEventSettlementFactory)
    station = factory.SubFactory(WizardDirectionSegmentEventStationFactory)
    local_datetime = factory.SubFactory(WizardDirectionSegmentEventDTFactory)


class WizardDirectionSegmentFactory(factory.DictFactory):
    arrival = factory.SubFactory(WizardDirectionSegmentEventFactory)
    departure = factory.SubFactory(WizardDirectionSegmentEventFactory)
    train = factory.SubFactory(WizardDirectionSegmentTrainFactory)
    duration = 360  # минуты

    @classmethod
    def create(cls, **kwargs):
        arrival_station = kwargs.pop('arrival_station', None)
        if arrival_station:
            kwargs['arrival__station__key'] = arrival_station.point_key
            kwargs['arrival__station__title'] = arrival_station.title

            arrival_settlement = arrival_station.settlement
            kwargs['arrival__settlement__key'] = arrival_settlement and arrival_settlement.point_key
            kwargs['arrival__settlement__title'] = arrival_settlement and arrival_settlement.title

        departure_station = kwargs.pop('departure_station', None)
        if departure_station:
            kwargs['departure__station__key'] = departure_station.point_key
            kwargs['departure__station__title'] = departure_station.title

            departure_settlement = departure_station.settlement
            kwargs['departure__settlement__key'] = departure_settlement and departure_settlement.point_key
            kwargs['departure__settlement__title'] = departure_settlement and departure_settlement.title

        arrival_dt = kwargs.pop('arrival_dt', None)
        if arrival_dt:
            if not arrival_dt.tzinfo:
                MSK_TZ.localize(arrival_dt)
            kwargs['arrival__local_datetime__value'] = arrival_dt.isoformat()
            kwargs['arrival__local_datetime__timezone'] = arrival_dt.tzinfo.zone

        departure_dt = kwargs.pop('departure_dt', None)
        if departure_dt:
            if not departure_dt.tzinfo:
                MSK_TZ.localize(departure_dt)
            kwargs['departure__local_datetime__value'] = departure_dt.isoformat()
            kwargs['departure__local_datetime__timezone'] = departure_dt.tzinfo.zone

        if arrival_dt and departure_dt:
            kwargs['duration'] = int(timedelta2minutes(arrival_dt - departure_dt))

        return super(WizardDirectionSegmentFactory, cls).create(**kwargs)


class WizardDirectionFactory(factory.DictFactory):
    segments = factory.List([factory.SubFactory(WizardDirectionSegmentFactory)])
