# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from datetime import datetime

import pytz
import six

WIZARD_DATETIME_FORMAT = '%Y-%m-%dT%H:%M:%S'


def get_dt(wizard_dt_str, timezone):
    if isinstance(timezone, six.string_types):
        timezone = pytz.timezone(timezone)
    return timezone.localize(datetime.strptime(wizard_dt_str[:19], WIZARD_DATETIME_FORMAT))


def get_dt_from_wizard_dict(wizard_dt_dict):
    return get_dt(wizard_dt_dict['value'], wizard_dt_dict['timezone'])
