PY2_LIBRARY(train_api)

OWNER(
    g:rasp-back
    g:trains-back
)

PEERDIR(
    contrib/python/apispec/py2
    contrib/python/grpcio-opentracing
    contrib/python/django-debug-toolbar
    contrib/python/factory-boy
    contrib/python/Flask
    contrib/python/jaeger-client
    contrib/python/six
    contrib/python/unicodecsv

    scarab/api/python3
    yt/python/client

    travel/library/python/gunicorn/worker_watcher
    travel/library/python/dicts/trains
    travel/library/python/tracing/django
    travel/library/python/tracing/gunicorn
    travel/library/python/tracing/instrumentation
    travel/library/python/solomon

    travel/library/python/entrypoint
    travel/library/python/rasp_vault

    travel/rasp/library/python/common
    travel/rasp/library/python/route_search

    travel/rasp/train_bandit_api/proto

    travel/trains/worker/api
)

IF (PYTHON2)
    PEERDIR(
        contrib/python/typing
    )
ENDIF()

PY_SRCS(
    TOP_LEVEL
    settings.py
    tests_settings.py
)

PY_SRCS(
    conftest.py

    gunicorn_conf_async.py
    monkey_patch.py
    monkey_patch_flask.py
    wsgi.py
    wsgi_async.py

    app.py
    docker/local_settings.py
    __init__.py
    app_django.py
    celery/__init__.py
    celery/app.py
    celery/worker.py
    data_layer/__init__.py
    data_layer/point.py
    data_layer/popular_directions.py
    data_layer/search_sample_points.py
    data_layer/settlement.py
    data_layer/train_popular_directions.py
    debug_urls.py
    helpers/__init__.py
    helpers/bunker.py
    helpers/data_converter.py
    helpers/decorators.py
    helpers/error.py
    helpers/expmap.py
    helpers/factory.py
    helpers/request.py
    helpers/rps_limiter.py
    helpers/serialization.py
    helpers/ydb.py
    management/__init__.py
    management/commands/__init__.py
    management/commands/collect_payment_info.py
    management/commands/dev_make_active_contracts.py
    management/commands/ensure_mongo_indexes.py
    middleware/__init__.py
    middleware/set_locale.py
    middleware/ping.py
    pb_provider/__init__.py
    pb_provider/data_provider.py
    popular_directions/__init__.py
    popular_directions/serialization.py
    popular_directions/settlement_images.py
    popular_directions/views.py
    scripts/__init__.py
    scripts/check_external_refunds.py
    scripts/clean_logs_user_data.py
    scripts/export_data_for_google_ads.py
    scripts/export_orders_and_refunds.py
    scripts/fill_displayed_coach_owner.py
    scripts/force_clear_payment.py
    scripts/force_payment_refund.py
    scripts/orders_report.py
    scripts/re_checkout_insurance.py
    scripts/restart_application.py
    scripts/set_orders_travel_status.py
    scripts/set_route_info.py
    scripts/sync_travelers/__init__.py
    scripts/sync_travelers/client.py
    scripts/sync_travelers/models.py
    scripts/sync_travelers/schemas.py
    scripts/sync_travelers/sync_orders.py
    scripts/ydb/__init__.py
    scripts/ydb/archive_logs.py
    scripts/ydb/create_log_table.py
    scripts/ydb/log_source_benchmark.py
    scripts/ydb/migrate_mongo_logs.py
    search/__init__.py
    search/serialization.py
    search/views.py
    serialization/__init__.py
    serialization/experiment.py
    serialization/fields.py
    serialization/schema_bases.py
    serialization/segment.py
    serialization/segment_station.py
    serialization/segment_transport.py
    tariffs/__init__.py
    tariffs/serialization.py
    tariffs/train/__init__.py
    tariffs/train/base/__init__.py
    tariffs/train/base/availability_indication.py
    tariffs/train/base/coach_category_traits.py
    tariffs/train/base/country_availability_manager.py
    tariffs/train/base/models.py
    tariffs/train/base/price_logging.py
    tariffs/train/base/query.py
    tariffs/train/base/query_result_manager.py
    tariffs/train/base/segments.py
    tariffs/train/base/serialization.py
    tariffs/train/base/service.py
    tariffs/train/base/train_tariffs.py
    tariffs/train/base/utils.py
    tariffs/train/base/worker.py
    tariffs/train/factories/__init__.py
    tariffs/train/factories/base.py
    tariffs/train/factories/im.py
    tariffs/train/im/__init__.py
    tariffs/train/im/parser.py
    tariffs/train/im/scarab_logger.py
    tariffs/train/im/send_query.py
    tariffs/train/segment_builder/__init__.py
    tariffs/train/segment_builder/plain_prices.py
    tariffs/train/segment_builder/prices_and_reasons.py
    tariffs/train/segment_builder/search_segments.py
    tariffs/train/segment_builder/helpers/__init__.py
    tariffs/train/segment_builder/helpers/black_list.py
    tariffs/train/segment_builder/helpers/merge_trains.py
    tariffs/train/segment_builder/helpers/sales_depth.py
    tariffs/train/segment_builder/helpers/title_common.py
    tariffs/train/views.py
    tariffs/train/wizard/__init__.py
    tariffs/train/wizard/service.py
    train_bandit_api/__init__.py
    train_bandit_api/client.py
    train_bandit_api/logging.py
    train_partners/__init__.py
    train_partners/mock_im.py
    train_partners/base/__init__.py
    train_partners/base/confirm_ticket.py
    train_partners/base/electronic_registration.py
    train_partners/base/factories/__init__.py
    train_partners/base/factories/coach_schemas.py
    train_partners/base/get_order_info.py
    train_partners/base/get_route_info.py
    train_partners/base/insurance/__init__.py
    train_partners/base/insurance/checkout.py
    train_partners/base/insurance/pricing.py
    train_partners/base/insurance/refund.py
    train_partners/base/prolong_reservation.py
    train_partners/base/refund.py
    train_partners/base/refund_amount.py
    train_partners/base/reserve_tickets.py
    train_partners/base/serialization.py
    train_partners/base/ticket_blank.py
    train_partners/base/train_details/__init__.py
    train_partners/base/train_details/coach_schemas.py
    train_partners/base/train_details/lazy_bandit_cost_cache.py
    train_partners/base/train_details/models.py
    train_partners/base/train_details/parsers.py
    train_partners/base/train_details/price_rules.py
    train_partners/base/train_details/reservation_variants.py
    train_partners/base/train_details/serialization.py
    train_partners/base/train_details/service_classes.py
    train_partners/base/train_details/tariff_calculator/__init__.py
    train_partners/base/train_details/tariff_calculator/adult_tariffs.py
    train_partners/base/train_details/tariff_calculator/child_tariffs.py
    train_partners/base/train_details/tariff_calculator/fee.py
    train_partners/base/train_details/tariff_calculator/non_refundable.py
    train_partners/base/train_details/tariff_calculator/tariff_calculator.py
    train_partners/base/train_details/utils.py
    train_partners/base/update_order.py
    train_partners/base/test_utils.py
    train_partners/config.py
    train_partners/im/__init__.py
    train_partners/im/base.py
    train_partners/im/confirm_ticket.py
    train_partners/im/electronic_registration.py
    train_partners/im/factories/__init__.py
    train_partners/im/factories/create_reservation.py
    train_partners/im/factories/order_info.py
    train_partners/im/factories/prolong_reservation.py
    train_partners/im/factories/utils.py
    train_partners/im/get_order_info.py
    train_partners/im/get_route_info.py
    train_partners/im/insurance/__init__.py
    train_partners/im/insurance/checkout.py
    train_partners/im/insurance/pricing.py
    train_partners/im/insurance/refund.py
    train_partners/im/partner_balance.py
    train_partners/im/prolong_reservation.py
    train_partners/im/refund.py
    train_partners/im/refund_amount.py
    train_partners/im/reserve_tickets.py
    train_partners/im/schedule.py
    train_partners/im/ticket_blank.py
    train_partners/im/train_details/__init__.py
    train_partners/im/train_details/parsers.py
    train_partners/im/train_details/receiver.py
    train_partners/im/train_details/yt_log.py
    train_partners/im/update_order.py
    train_partners/ufs/__init__.py
    train_partners/ufs/base.py
    train_partners/ufs/confirm_ticket.py
    train_partners/ufs/electronic_registration.py
    train_partners/ufs/get_order_info.py
    train_partners/ufs/refund.py
    train_partners/ufs/refund_amount.py
    train_partners/ufs/reserve_tickets.py
    train_partners/ufs/ticket_blank.py
    train_partners/ufs/train_details/__init__.py
    train_partners/ufs/train_details/parsers.py
    train_partners/ufs/train_details/receiver.py
    train_partners/ufs/train_details/utils.py
    train_partners/ufs/update_order.py
    train_partners/ufs/test_utils/__init__.py
    train_partners/ufs/test_utils/response_factories.py
    train_purchase/__init__.py
    train_purchase/backoffice/__init__.py
    train_purchase/backoffice/base.py
    train_purchase/backoffice/order_logs.py
    train_purchase/backoffice/orders/__init__.py
    train_purchase/backoffice/orders/search.py
    train_purchase/backoffice/orders/serialization.py
    train_purchase/backoffice/orders/views.py
    train_purchase/backoffice/refund/__init__.py
    train_purchase/backoffice/refund/views.py
    train_purchase/backoffice/serialization.py
    train_purchase/backoffice/support/__init__.py
    train_purchase/backoffice/support/views.py
    train_purchase/backoffice/trust_info/__init__.py
    train_purchase/backoffice/trust_info/serialization.py
    train_purchase/backoffice/trust_info/views.py
    train_purchase/backoffice/urls.py
    train_purchase/backoffice/views.py
    train_purchase/core/__init__.py
    train_purchase/core/config.py
    train_purchase/core/directories.py
    train_purchase/core/enums.py
    train_purchase/core/factories.py
    train_purchase/core/models.py
    train_purchase/core/sms_verification.py
    train_purchase/core/utils.py
    train_purchase/factories.py
    train_purchase/serialization.py
    train_purchase/tasks/__init__.py
    train_purchase/tasks/cancel_expired_orders.py
    train_purchase/tasks/check_balance.py
    train_purchase/tasks/check_office_refunds.py
    train_purchase/tasks/clean_limiter.py
    train_purchase/tasks/clear_payments.py
    train_purchase/tasks/client_contracts.py
    train_purchase/tasks/collect_expired_orders.py
    train_purchase/tasks/collect_refund_blanks.py
    train_purchase/tasks/fill_payment_status_and_response.py
    train_purchase/tasks/finish_refund_payment/__init__.py
    train_purchase/tasks/finish_refund_payment/retry.py
    train_purchase/tasks/finish_refund_payment/send_fail_email.py
    train_purchase/tasks/finish_refund_payment/update_from_billing.py
    train_purchase/tasks/long_external_event_email.py
    train_purchase/tasks/refund_email.py
    train_purchase/tasks/revivers.py
    train_purchase/tasks/trust_products.py
    train_purchase/tasks/unhandled_exception_order.py
    train_purchase/tasks/unhandled_exception_refund.py
    train_purchase/tasks/unhold_invalid_payments.py
    train_purchase/utils/__init__.py
    train_purchase/utils/billing.py
    train_purchase/utils/decorators.py
    train_purchase/utils/electronic_registration.py
    train_purchase/utils/email_sender_callback.py
    train_purchase/utils/fee_calculator.py
    train_purchase/utils/logs.py
    train_purchase/utils/office_refund.py
    train_purchase/utils/order.py
    train_purchase/utils/order_tickets.py
    train_purchase/utils/pagination.py
    train_purchase/utils/refund_email.py
    train_purchase/utils/reviver_with_filter.py
    train_purchase/utils/sms_verification.py
    train_purchase/utils/tickets_email.py
    train_purchase/utils/tickets_sms.py
    train_purchase/utils/tvm.py
    train_purchase/views/__init__.py
    train_purchase/views/cpa/__init__.py
    train_purchase/views/cpa/serialization.py
    train_purchase/views/cpa/views.py
    train_purchase/views/insurance.py
    train_purchase/views/serialization.py
    train_purchase/views/test_utils.py
    train_purchase/views/travel.py
    train_purchase/views_async.py
    train_purchase/workflow/__init__.py
    train_purchase/workflow/base.py
    train_purchase/workflow/booking/__init__.py
    train_purchase/workflow/booking/cancel_order.py
    train_purchase/workflow/booking/cancel_payment.py
    train_purchase/workflow/booking/check_insurance.py
    train_purchase/workflow/booking/check_order.py
    train_purchase/workflow/booking/checkout_insurance.py
    train_purchase/workflow/booking/confirm_order.py
    train_purchase/workflow/booking/create_insurance_refund.py
    train_purchase/workflow/booking/create_payment.py
    train_purchase/workflow/booking/log_order.py
    train_purchase/workflow/booking/rebook_order.py
    train_purchase/workflow/booking/send_tickets_email.py
    train_purchase/workflow/booking/send_tickets_sms.py
    train_purchase/workflow/booking/set_insurance_status.py
    train_purchase/workflow/booking/set_pending.py
    train_purchase/workflow/booking/update_expired_order.py
    train_purchase/workflow/booking/update_order_status.py
    train_purchase/workflow/booking/update_order_tickets.py
    train_purchase/workflow/payment/__init__.py
    train_purchase/workflow/payment/cancel_payment.py
    train_purchase/workflow/payment/check_payment.py
    train_purchase/workflow/payment/clear_payment.py
    train_purchase/workflow/payment/create_payment.py
    train_purchase/workflow/payment/create_refund_payment.py
    train_purchase/workflow/payment/rebook_order.py
    train_purchase/workflow/payment/refund_payment.py
    train_purchase/workflow/payment/resize_payment.py
    train_purchase/workflow/payment/sending_payment_event.py
    train_purchase/workflow/ticket_refund/__init__.py
    train_purchase/workflow/ticket_refund/create_refund_payment.py
    train_purchase/workflow/ticket_refund/refund_managers.py
    train_purchase/workflow/ticket_refund/refund_order.py
    train_purchase/workflow/ticket_refund/send_refund_email.py
    train_purchase/workflow/ticket_refund/unset_is_active.py
    train_purchase/workflow/user_events.py
    urls_async.py
    wizard_api/__init__.py
    wizard_api/client.py
    wizard_api/factories.py
    wizard_api/helpers/__init__.py
    wizard_api/helpers/dt.py
    xgettext/__init__.py
)

RESOURCE_FILES(
    xgettext/keyset.json
)

RESOURCE_FILES(
    PREFIX travel/rasp/train_api/
    popular_directions/settlement_images.json
    popular_directions/settlement_image_defaults.json
)

END()

RECURSE(
    bin
)
