package server

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/metrics"
	"github.com/go-chi/chi/v5"
	"github.com/go-chi/chi/v5/middleware"
	"net/http"
	"time"
)

type HTTPConfig struct {
	Address                    string
	PerfMetricsRefreshInterval time.Duration `config:"PERF_METRICS_REFRESH_INTERVAL,required"`
	PerfMetricsPrefix          string
}

var DefaultHTTPConfig = HTTPConfig{
	Address:                    ":9000",
	PerfMetricsRefreshInterval: 5 * time.Second,
	PerfMetricsPrefix:          "perf",
}

func RunHTTPServer(config *HTTPConfig, logger log.Logger, metricsRegistry metrics.Registry) error {
	r := chi.NewRouter()
	r.Use(middleware.RequestID)
	r.Use(middleware.Recoverer)

	ping := func(w http.ResponseWriter, r *http.Request) {
		_, err := w.Write([]byte("Pong"))
		if err != nil {
			logger.Error("", log.Error(err))
		}
	}
	r.Get("/ping", ping)

	return http.ListenAndServe(config.Address, r)
}
