package manager

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/log"

	"a.yandex-team.ru/travel/rasp/train_bandit_api/internal/bandit"
)

const (
	BanditTypeFixed7    = "fix7"
	BanditTypeFixed9    = "fix9"
	BanditTypeFixed11   = "fix11"
	BanditTypeFixed13   = "fix13"
	BanditTypeFixed15   = "fix15"
	BanditTypeTutuLike  = "tl1"
	BanditTypeTutuLike2 = "tl2"
	BanditTypeTutuLike3 = "tl3"
)

type Config struct {
	DefaultBanditType string `config:"manager-default-bandit-type" yaml:"default-bandit-type"`
}

var DefaultConfig = Config{
	DefaultBanditType: BanditTypeTutuLike3,
}

type Manager struct {
	defaultType string
	logger      log.Logger
	Bandits     map[string]bandit.Charger
}

func NewManager(config *Config, logger log.Logger) (*Manager, error) {
	m := Manager{
		defaultType: config.DefaultBanditType,
		logger:      logger,
		Bandits: map[string]bandit.Charger{
			BanditTypeFixed7:    bandit.NewFixedWithMinFee(70, 60),
			BanditTypeFixed9:    bandit.NewFixedWithMinFee(90, 60),
			BanditTypeFixed11:   bandit.NewFixedWithMinFee(110, 60),
			BanditTypeFixed13:   bandit.NewFixedWithMinFee(130, 60),
			BanditTypeFixed15:   bandit.NewFixedWithMinFee(150, 60),
			BanditTypeTutuLike:  bandit.NewTutuLike(15),
			BanditTypeTutuLike2: bandit.NewTutuLike2(15),
			BanditTypeTutuLike3: bandit.NewTutuLike3(15),
		},
	}

	return &m, nil
}

func (m *Manager) GetCharger(banditType string) (bandit.Charger, string, uint64, error) {
	if banditType == "" {
		banditType = m.defaultType
	}
	b, ok := m.Bandits[banditType]
	if !ok {
		return nil, banditType, 0, fmt.Errorf("not found bandit with type=%s", banditType)
	}
	return b, banditType, 0, nil
}
