package bandit

import (
	"a.yandex-team.ru/travel/rasp/train_bandit_api/internal/model"
	pb "a.yandex-team.ru/travel/rasp/train_bandit_api/proto"
)

type TutuLike2 struct {
	minTariffPermille *uint32
}

func NewTutuLike2(minTariffPermille uint32) *TutuLike2 {
	return &TutuLike2{minTariffPermille: &minTariffPermille}
}

func (b *TutuLike2) GetCharge(ctx *pb.TContext) (permille uint32, minTariffPermille *uint32, err error) {
	if ctx.CarType == model.CarTypeSitting && ctx.TrainType == model.TrainTypeSapsan {
		return 100, b.minTariffPermille, nil
	}
	if ctx.CarType == model.CarTypePlatzkarte {
		return 90, b.minTariffPermille, nil
	}
	if ctx.CarType == model.CarTypeCompartment {
		return 130, b.minTariffPermille, nil
	}
	return 180, b.minTariffPermille, nil
}
