package bandit

import (
	"a.yandex-team.ru/travel/rasp/train_bandit_api/internal/model"
	pb "a.yandex-team.ru/travel/rasp/train_bandit_api/proto"
)

type TutuLike3 struct {
	minTariffPermille *uint32
}

func NewTutuLike3(minTariffPermille uint32) *TutuLike3 {
	return &TutuLike3{minTariffPermille: &minTariffPermille}
}

func (b *TutuLike3) GetCharge(ctx *pb.TContext) (permille uint32, minTariffPermille *uint32, err error) {
	if ctx.CarType == model.CarTypeSitting && ctx.TrainType == model.TrainTypeSapsan {
		return 100, b.minTariffPermille, nil
	}
	if ctx.CarType == model.CarTypePlatzkarte {
		return 60, b.minTariffPermille, nil
	}
	return 180, b.minTariffPermille, nil
}
