package logging

import (
	"fmt"
	"syscall"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/library/go/core/log/zap/logrotate"
)

type Config struct {
	Level string `config:"log-level" yaml:"level"`
}

var DefaultConfig = Config{
	Level: "info",
}

func New(config *Config) (*zap.Logger, error) {
	level, err := log.ParseLevel(config.Level)
	if err != nil {
		return nil, fmt.Errorf("bad log level format: %w", err)
	}

	logger, err := zap.NewDeployLogger(level)
	if err != nil {
		return nil, fmt.Errorf("cannot create logger: %w", err)
	}

	return logger, nil
}

func EnableLogrotate() error {
	return logrotate.RegisterLogrotateSink(syscall.SIGHUP)
}
