package expmap

import (
	"fmt"
	"strings"
)

const (
	ExpMapEntriesSeparator  = ";"
	ExpMapKeyValueSeparator = ":"

	ExpBoxesEntriesSeparator = ";"
	ExpBoxesValuesSeparator  = ","
)

type ExperimentMap map[string]string

func ParseExperimentMap(s string) (em ExperimentMap, err error) {
	entries := strings.Split(s, ExpMapEntriesSeparator)
	em = make(map[string]string, len(entries))
	for _, entry := range entries {
		if entry == "" {
			continue
		}
		ss := strings.Split(entry, ExpMapKeyValueSeparator)
		if len(ss) != 2 {
			return nil, fmt.Errorf("invalid entry format: %v", entry)
		}
		key, value := ss[0], ss[1]
		if _, ok := em[key]; ok {
			return nil, fmt.Errorf("multiple entrance of key: %v", key)
		}
		em[key] = value
	}
	return em, nil
}

func ParseExpBoxes(s string) (testIds []string, err error) {
	entries := strings.Split(s, ExpBoxesEntriesSeparator)
	testIds = make([]string, 0, len(entries))
	for _, entry := range entries {
		ss := strings.Split(entry, ExpBoxesValuesSeparator)
		if ss[0] == "" {
			continue
		}
		testIds = append(testIds, ss[0])
	}
	return testIds, nil
}

func (m ExperimentMap) expValueFromTestIds(ss []string) (res string, err error) {
	for _, s := range ss {
		v, ok := m[s]
		if ok {
			if res == "" {
				res = v
			} else if res != v {
				return res, fmt.Errorf("found many testIds from expmap")
			}
		}
	}
	return res, nil
}

func (m ExperimentMap) ExpValueFromExpBoxes(expBoxes string) (res string, err error) {
	ss, err := ParseExpBoxes(expBoxes)
	if err != nil {
		return "", err
	}
	return m.expValueFromTestIds(ss)
}
