package utils

import (
	"encoding/base64"
	"fmt"

	pb "a.yandex-team.ru/travel/rasp/train_bandit_api/proto"
	"github.com/golang/protobuf/proto"
)

func MarshalToStr(m proto.Message) (string, error) {
	contextBytes, err := proto.Marshal(m)
	if err != nil {
		return "", fmt.Errorf("invalid marshaler: %w", err)
	}
	return base64.StdEncoding.EncodeToString(contextBytes), nil
}

func BanditContextFromStr(c string) (*pb.TContext, error) {
	contextBytes, err := base64.StdEncoding.DecodeString(c)
	if err != nil {
		return nil, fmt.Errorf("can not decode base64 string: %w", err)
	}
	context := pb.TContext{}
	err = proto.Unmarshal(contextBytes, &context)
	if err != nil {
		return nil, fmt.Errorf("can not unmarshal context: %w", err)
	}
	return &context, nil
}

func BanditTokenFromStr(c string) (*pb.TFeeCalculationToken, error) {
	contextBytes, err := base64.StdEncoding.DecodeString(c)
	if err != nil {
		return nil, fmt.Errorf("can not decode base64 string: %w", err)
	}
	context := pb.TFeeCalculationToken{}
	err = proto.Unmarshal(contextBytes, &context)
	if err != nil {
		return nil, fmt.Errorf("can not unmarshal fee calculation token: %w", err)
	}
	return &context, nil
}
