package utils

import (
	tpr "a.yandex-team.ru/travel/proto"
	"math"
)

func ToProtoPriceRUB(value float64) *tpr.TPrice {
	return ToProtoPrice(value, tpr.ECurrency_C_RUB, 2)
}

func ToProtoPrice(value float64, currency tpr.ECurrency, precision int32) *tpr.TPrice {
	return &tpr.TPrice{
		Amount:    int64(value*math.Pow10(int(precision)) + 0.5),
		Precision: precision,
		Currency:  currency,
	}
}

func FromProtoPrice(price *tpr.TPrice) float64 {
	return float64(price.Amount) / math.Pow10(int(price.Precision))
}
