package main

import (
	"bufio"
	"context"
	"fmt"
	"os"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/proto/trains"
	"a.yandex-team.ru/travel/rasp/train_offer_storage/internal/api/models"
	"github.com/gofrs/uuid"
	"github.com/golang/protobuf/proto"
)

func console(ctx context.Context, logger log.Logger, s models.Storager) {
	reader := bufio.NewReader(os.Stdin)
	for {
		fmt.Print("Enter command: ")
		text, _ := reader.ReadString('\n')
		switch text {
		case "exit\n":
			return
		case "ping\n":
			fmt.Println("pong")
		case "create-table\n":
			err := s.CreateTable(ctx)
			if err == nil {
				fmt.Println("success creating table")
			} else {
				fmt.Printf("error creating table: %v\n", err)
			}
		case "get-offer\n":
			fmt.Print("Enter offer id: ")
			offerIDStr, _ := reader.ReadString('\n')
			offerIDStr = offerIDStr[:len(offerIDStr)-1]
			offerID, err := uuid.FromString(offerIDStr)
			if err != nil {
				fmt.Printf("invalid offer id: %v\n%v\n", offerIDStr, err)
			}
			offerData, err := s.Get(ctx, offerID)
			if err != nil {
				fmt.Printf("error get offer: %v\n", err)
			}
			offer := trains.TTrainServiceOffer{}
			err = proto.Unmarshal(offerData, &offer)
			if err != nil {
				fmt.Printf("error unmarshal offer: %v\n", err)
			}
			offerStr := offer.String()
			fmt.Println(offerStr)
		default:
			fmt.Printf("unknown command: %v", text)
		}
	}
}
