package models

import (
	"context"
	"github.com/gofrs/uuid"
)

type Storager interface {
	Get(ctx context.Context, token uuid.UUID) (data []byte, err error)
	GetMany(ctx context.Context, tokens []uuid.UUID) (datas [][]byte, err error)
	CreateTable(ctx context.Context) error
	Save(ctx context.Context, data []byte, token uuid.UUID) error
	Close(ctx context.Context) error
}
