package models

import "fmt"

type StoreOfferRequest struct {
	TrainNumber                 string                         `json:"train_number"`
	TrainTicketNumber           string                         `json:"train_ticket_number"`
	TrainTitle                  string                         `json:"train_title"`
	BrandTitle                  string                         `json:"brand_title"`
	RawTrainName                string                         `json:"raw_train_name"`
	StationFromID               uint32                         `json:"station_from_id"`
	StationToID                 uint32                         `json:"station_to_id"`
	Departure                   string                         `json:"departure"`
	Arrival                     string                         `json:"arrival"`
	CabinGenderKind             string                         `json:"cabin_gender_kind"`
	CarNumber                   string                         `json:"car_number"`
	CarType                     string                         `json:"car_type"`
	CompanyTitle                string                         `json:"company_title"`
	ServiceClass                string                         `json:"service_class"`
	InternationalServiceClass   string                         `json:"international_service_class"`
	RoutePolicy                 string                         `json:"route_policy"`
	Provider                    string                         `json:"provider"`
	IsCppk                      bool                           `json:"is_cppk"`
	SchemeID                    uint32                         `json:"scheme_id"`
	ElectronicRegistration      bool                           `json:"electronic_registration"`
	Bedding                     bool                           `json:"bedding"`
	CanChooseBedding            *bool                          `json:"can_choose_bedding"`
	GiveChildWithoutPlace       bool                           `json:"give_child_without_place"`
	Passengers                  []OfferRequestPassenger        `json:"passengers"`
	Places                      []uint32                       `json:"places"`
	Requirements                *OfferRequestPlaceRequirements `json:"requirements"`
	AdditionalPlaceRequirements string                         `json:"additional_place_requirements"`
	Partner                     string                         `json:"partner"`
	LabelParams                 *OfferRequestLabelParams       `json:"label_params"`
	ImInitialStationName        string                         `json:"im_initial_station_name"`
	ImFinalStationName          string                         `json:"im_final_station_name"`
	Amount                      float64                        `json:"amount"`
	BanditType                  string                         `json:"bandit_type"`
	FeeCalculationToken         string                         `json:"fee_calculation_token"`
	Direction                   string                         `json:"direction"`
	SegmentIndex                uint32                         `json:"segment_index"`
}

type OfferRequestPassenger struct {
	Index                 uint32                    `json:"index"`
	Sex                   string                    `json:"sex"`
	DocType               string                    `json:"doc_type"`
	CitizenshipGeoID      uint32                    `json:"citizenship_geo_id"`
	LoyaltyCards          []OfferRequestLoyaltyCard `json:"loyalty_cards"`
	Tariff                string                    `json:"tariff"`
	AgeGroup              string                    `json:"age_group"`
	Places                []uint32                  `json:"places"`
	IsNonRefundableTariff bool                      `json:"is_non_refundable_tariff"`
}

type OfferRequestLoyaltyCard struct {
	CardType string `json:"type"`
	Number   string `json:"number"`
}

type OfferRequestPlaceRequirements struct {
	Arrangement string                  `json:"arrangement"`
	Storey      uint32                  `json:"number"`
	Count       *OfferRequestPlaceCount `json:"count"`
}

type OfferRequestPlaceCount struct {
	Bottom      uint32 `json:"bottom"`
	Upper       uint32 `json:"upper"`
	NearWindow  uint32 `json:"near_window"`
	NearPassage uint32 `json:"near_passage"`
}

type OfferRequestLabelParams struct {
	SerpReqID        string `json:"req_id"`
	UtmSource        string `json:"utm_source"`
	UtmMedium        string `json:"utm_medium"`
	UtmCampaign      string `json:"utm_campaign"`
	UtmTerm          string `json:"utm_term"`
	UtmContent       string `json:"utm_content"`
	From             string `json:"from"`
	GClID            string `json:"gclid"`
	ICookie          string `json:"icookie"`
	SerpUUID         string `json:"serp_uuid"`
	TestBuckets      string `json:"test_buckets"`
	Partner          string `json:"partner"`
	SubPartner       string `json:"sub_partner"`
	PartnerUID       string `json:"partner_uid"`
	Device           string `json:"device"`
	Terminal         string `json:"terminal"`
	IsTransfer       bool   `json:"is_transfer"`
	IP               string `json:"ip"`
	RegionID         uint32 `json:"region_id"`
	UID              string `json:"uid"`
	YandexUID        string `json:"yandex_uid"`
	WizardReqID      string `json:"wizard_req_id"`
	SerpTestID       string `json:"serp_test_id"`
	YtpReferer       string `json:"ytp_referer"`
	Yclid            string `json:"yclid"`
	Fbclid           string `json:"fbclid"`
	MetrikaClientID  string `json:"metrika_client_id"`
	Clid             string `json:"clid"`
	AdmitadUID       string `json:"admitad_uid"`
	TravelpayoutsUID string `json:"travelpayouts_uid"`
	Vid              string `json:"vid"`
	AffiliateClid    string `json:"affiliate_clid"`
	AffliliateVid    string `json:"affliliate_vid"`
}

func (req *StoreOfferRequest) Validate() error {
	if req.LabelParams == nil || req.LabelParams.ICookie == "" {
		return fmt.Errorf("missing required field: label_params.icookie")
	}
	if req.Departure == "" {
		return fmt.Errorf("missing required field: departure")
	}
	if req.Arrival == "" {
		return fmt.Errorf("missing required field: arrival")
	}
	if req.TrainNumber == "" {
		return fmt.Errorf("missing required field: train_number")
	}
	if req.StationToID == 0 {
		return fmt.Errorf("missing required field: station_to_id")
	}
	if req.StationFromID == 0 {
		return fmt.Errorf("missing required field: station_from_id")
	}
	if len(req.Passengers) == 0 {
		return fmt.Errorf("missing required field: passengers")
	}
	for i := 0; i < len(req.Passengers); i++ {
		requestPassenger := req.Passengers[i]
		if requestPassenger.Tariff == "" {
			return fmt.Errorf("missing required field: passengers.tariff")
		}
		if requestPassenger.AgeGroup == "" {
			return fmt.Errorf("missing required field: passengers.age_group")
		}
		if requestPassenger.DocType == "" {
			return fmt.Errorf("missing required field: passengers.doc_type")
		}
	}
	return nil
}
