package logging

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	grpcZap "github.com/grpc-ecosystem/go-grpc-middleware/logging/zap"
)

type Config struct {
	Level      string `yaml:"level"`
	EnableGrpc bool   `yaml:"enable-grpc"`
}

var DefaultConfig = Config{
	Level:      "info",
	EnableGrpc: false,
}

func New(config *Config) (*zap.Logger, error) {
	level, err := log.ParseLevel(config.Level)
	if err != nil {
		return nil, fmt.Errorf("bad log level format: %w", err)
	}

	logger, err := zap.NewDeployLogger(level)
	if err != nil {
		return nil, fmt.Errorf("cannot create logger: %w", err)
	}
	if config.EnableGrpc {
		grpcZap.ReplaceGrpcLoggerV2(logger.L)
	}
	return logger, nil
}
