#!/usr/bin/env python
# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import os

import click
import django

from travel.rasp.library.python.common23.logging import create_current_file_run_log

click.disable_unicode_literals_warning = True


@click.group()
def cli():
    pass


@cli.command()
@click.option("--dry-run", help="Dry run (do not upload)", is_flag=True)
def dump_actual_directions(dry_run):
    # type: (bool) -> None
    os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'travel.rasp.trains.scripts.dump_actual_directions.settings')
    django.setup()
    create_current_file_run_log()

    from travel.rasp.trains.scripts.dump_actual_directions.dump_actual_directions import dump_actual_directions
    dump_actual_directions(dry_run)


@cli.command()
@click.option("--check", help="Check sitemaps", is_flag=True)
@click.option("--dry-run", help="Dry run (do not upload)", is_flag=True)
def generate_sitemap(check, dry_run):
    # type: (bool, bool) -> None
    os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'travel.rasp.trains.scripts.generate_sitemap.settings')
    django.setup()
    create_current_file_run_log()

    from travel.rasp.trains.scripts.generate_sitemap.generate_sitemap import generate_sitemap
    generate_sitemap(check, dry_run)


if __name__ == '__main__':
    cli()
