# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import tempfile

from common.settings import *  # noqa: F403 (unable to detect undefined names)
from common.settings.configuration import BaseConfigurator, Configuration, DynamicSettingsMongoConfigurator

INSTALLED_APPS = COMMON_CONTRIB_APPS + COMMON_INSTALLED_APPS + [  # noqa: F405 (name may be undefined)
    'django.contrib.sites',

    'route_search',
]

LOG_PATH = tempfile.gettempdir()
LOG_FORMAT = '%(levelname)s %(asctime)s %(process)d %(name)s %(message)s'

YT_PROXY = 'hahn'


class DumpActualDirectionsConfigurator(BaseConfigurator):
    def apply_testing(self, settings):
        settings['DUMP_ACTUAL_DIRECTIONS_OUTPUT'] = '//home/rasp/trains/actual_directions/testing/directions'

    def apply_production(self, settings):
        settings['DUMP_ACTUAL_DIRECTIONS_OUTPUT'] = '//home/rasp/trains/actual_directions/production/directions'


Configuration([
    'misc',
    'mysql',
    DynamicSettingsMongoConfigurator,
    DumpActualDirectionsConfigurator,
]).apply(globals())
