# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import tempfile

from common.settings import *  # noqa: F403 (unable to detect undefined names)
from common.settings.configuration import BaseConfigurator, Configuration, DynamicSettingsMongoConfigurator

INSTALLED_APPS = COMMON_CONTRIB_APPS + COMMON_INSTALLED_APPS + [  # noqa: F405 (name may be undefined)
    'route_search'
]

YT_PROXY = 'hahn.yt.yandex.net'


LOG_PATH = tempfile.gettempdir()
LOG_FORMAT = '%(levelname)s %(asctime)s %(process)d %(name)s %(message)s'


class GenerateCrossLinksConfigurator(BaseConfigurator):
    def apply_testing(self, settings):
        settings['CROSS_LINKS_YT_TABLE'] = '//home/rasp/trains/crosslinks/testing/crosslinks'

    def apply_production(self, settings):
        settings['CROSS_LINKS_YT_TABLE'] = '//home/rasp/trains/crosslinks/production/crosslinks'


Configuration([
    'misc',
    'mysql',
    DynamicSettingsMongoConfigurator,  # /lib/fetch_routes
    GenerateCrossLinksConfigurator
]).apply(globals())
