# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import datetime
import json

from django.conf import settings

from yql.api.v1.client import YqlClient
from yql.client.parameter_value_builder import YqlParameterValueBuilder


STAT_QUERY = '''
USE hahn;

DECLARE $date_min AS Date;
DECLARE $date_max AS Date;

SELECT point_from, point_to, Count(1) as cnt FROM (
        SELECT
            Yson::ConvertToString(request.point_from) AS point_from,
            Yson::ConvertToString(request.point_to) AS point_to,
        FROM
            RANGE(
                `home/logfeller/logs/travel-trains-search_api-search_log-production/1d`,
                CAST($date_min AS String),
                CAST($date_max AS String)
            )
)
GROUP BY point_from, point_to
ORDER BY cnt DESC
'''


def stat_yql(days_period=30, yql_token=settings.YQL_TOKEN):
    date_max = datetime.date.today()
    date_min = date_max - datetime.timedelta(days=days_period)

    with YqlClient(token=yql_token) as yql_client:
        request = yql_client.query(STAT_QUERY)
        request.run(parameters=YqlParameterValueBuilder.build_json_map({
            '$date_min': YqlParameterValueBuilder.make_date(date_min),
            '$date_max': YqlParameterValueBuilder.make_date(date_max),
        }))
        return {(row[0], row[1]): row[2] for table in request for row in table.get_iterator()}


def get_stat_from_file(file_path):
    stat = {}
    with open(file_path) as f:
        for line in f.readlines():
            stat_line = json.loads(line)
            stat[(stat_line['point_from'], stat_line['point_to'])] = stat_line['cnt']

    return stat
