# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from common.data_api.file_wrapper.config import FileWrapperConfigs
from common.data_api.file_wrapper.wrappers import MdsDirectoryWrapper, LocalDirectoryWrapper
from common.db.mds.clients import mds_s3_public_client
from common.settings.configuration import Configuration


class FileType(object):
    MEDIA_TRAIN_ROOT = 'MEDIA_TRAIN_ROOT'
    MEDIA_TRAVEL_TRAIN_ROOT = 'MEDIA_TRAVEL_TRAIN_ROOT'


def get_mds_root_kwargs(root):
    return {
        Configuration.DEVELOPMENT: {
            'class': LocalDirectoryWrapper,
        },
        'default': {
            'class': MdsDirectoryWrapper,
            'kwargs': {
                'mds_client': mds_s3_public_client,
                'upload_params': {
                    'mds_base_path': root,
                    'ignore_files': ['readme', 'readme.md'],
                    'ignore_case': True
                }
            }
        }
    }


FileWrapperConfigs.register_config(
    key=FileType.MEDIA_TRAIN_ROOT,
    config=get_mds_root_kwargs('train-root')
)

FileWrapperConfigs.register_config(
    key=FileType.MEDIA_TRAVEL_TRAIN_ROOT,
    config=get_mds_root_kwargs('travel-train-root')
)
