# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import abc
import typing
from django.utils import six

from travel.rasp.library.python.sitemap.models.from_urls_list import CommonSitemap


@six.add_metaclass(abc.ABCMeta)
class AbstractSitemap(CommonSitemap):
    changefreq = 'daily'

    def __init__(self, items):
        # type: (typing.Iterable[typing.Tuple[typing.Text, typing.Text]]) -> None
        super(AbstractSitemap, self).__init__()
        self._items = items

    def items(self):
        # type: () -> typing.Iterable[typing.Tuple[typing.Text, typing.Text]]
        return self._items

    @abc.abstractmethod
    def location(self, item):
        raise NotImplementedError


class TrainSitemap(AbstractSitemap):
    def location(self, item):
        # type: (typing.Tuple[typing.Text, typing.Text]) -> typing.Text
        from_slug, to_slug = item
        return '/{}--{}'.format(
            from_slug,
            to_slug
        )


class TravelTrainSitemap(AbstractSitemap):
    def location(self, item):
        # type: (typing.Tuple[typing.Text, typing.Text]) -> typing.Text
        from_slug, to_slug = item
        return '/trains/{}--{}/'.format(
            from_slug,
            to_slug
        )
