# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import tempfile

from common.settings import *  # noqa: F403 (unable to detect undefined names)
from common.settings.configuration import Configuration, DynamicSettingsMongoConfigurator

INSTALLED_APPS = COMMON_CONTRIB_APPS + COMMON_INSTALLED_APPS + [  # noqa: F405 (name may be undefined)
    'django.contrib.sites',
    'travel.rasp.library.python.sitemap',

    'route_search',
]

TEMPLATES = [
    {
        'BACKEND': 'library.python.django.template.backends.arcadia.ArcadiaTemplates',
        'OPTIONS': {
            'debug': False,
            'loaders': [
                'library.python.django.template.loaders.app_resource.Loader',
            ],
        },
    }
]

LOG_PATH = tempfile.gettempdir()
LOG_FORMAT = '%(levelname)s %(asctime)s %(process)d %(name)s %(message)s'

Configuration(['misc', 'mysql', DynamicSettingsMongoConfigurator]).apply(globals())
