# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import datetime
import typing

from yql.api.v1.client import YqlClient
from yql.client.parameter_value_builder import YqlParameterValueBuilder
from travel.library.python.rasp_vault.api import get_secret

SEARCHES_QUERY = '''
USE hahn;

DECLARE $date_min AS Date;
DECLARE $date_max AS Date;

SELECT settlement_from.Slug, settlement_to.Slug FROM (
    SELECT
        CAST(SUBSTRING(point_from, 1) AS UInt64) AS settlement_from_id,
        CAST(SUBSTRING(point_to, 1) AS UInt64) AS settlement_to_id,
    FROM (
        SELECT DISTINCT
            Yson::ConvertToString(request.point_from) AS point_from,
            Yson::ConvertToString(request.point_to) AS point_to,
        FROM
            RANGE(
                `home/logfeller/logs/travel-trains-search_api-search_log-production/1d`,
                CAST($date_min AS String),
                CAST($date_max AS String)
            )
    )
    WHERE StartsWith(point_from, 'c') AND StartsWith(point_to, 'c')
) AS search

INNER JOIN `home/travel/prod/rasp_dicts/latest/settlement` AS settlement_from
    ON settlement_from.Id = search.settlement_from_id

INNER JOIN `home/travel/prod/rasp_dicts/latest/settlement` AS settlement_to
    ON settlement_to.Id = search.settlement_to_id
'''


def fetch_searches(days_period=7, yql_token='rasp-robot-tokens-and-passwords.yql-token'):
    # type: (int, typing.Text) -> typing.Set[typing.Tuple[typing.Text, typing.Text]]
    date_max = datetime.date.today()
    date_min = date_max - datetime.timedelta(days=days_period)

    with YqlClient(token=get_secret(yql_token)) as yql_client:
        request = yql_client.query(SEARCHES_QUERY)
        request.run(parameters=YqlParameterValueBuilder.build_json_map({
            '$date_min': YqlParameterValueBuilder.make_date(date_min),
            '$date_max': YqlParameterValueBuilder.make_date(date_max),
        }))
        return {tuple(row) for table in request for row in table.get_iterator()}
