import logging

from travel.proto.dicts.trains.coach_binding_pb2 import TCoachBinding
from travel.proto.dicts.trains.coach_type_pb2 import TCoachType

from travel.rasp.trains.train_admin.train_admin.models import CoachBinding

log = logging.getLogger()


class CoachBindingDumper:
    def __init__(self, proto_writer):
        self.proto_writer = proto_writer

    @staticmethod
    def get_queryset():
        return CoachBinding.objects.all()

    def dump(self, schema_ids):
        for record in self.get_queryset():
            schema_id = record.schema_id
            if schema_id not in schema_ids:
                log.warning('Skipping CoachBinding: Can not find a schema by id {} for the binding with id {}'
                            .format(schema_id, record.id))
                continue

            proto = TCoachBinding()
            if record.klass:
                proto.Klass = TCoachType.EType.Value(record.klass.upper())
            proto.ServiceClass = record.service_class
            proto.InternationalServiceClass = record.international_service_class
            proto.StartSettlementId = record.start_settlement_id or 0
            proto.EndSettlementId = record.end_settlement_id or 0
            proto.CoachSubtype = record.coach_subtype_code
            proto.Road = record.road
            proto.TrainNumber = record.train_number
            proto.CoachNumber = record.coach_number
            proto.Priority = record.priority
            proto.SchemaId = schema_id
            proto.ConfirmedDirection = record.direction_confirmed
            self.proto_writer.write(proto)
