from travel.proto.dicts.trains.coach_schema_pb2 import TCoachSchema

from travel.rasp.trains.train_admin.train_admin.models import CoachSchema


class CoachSchemaDumper:
    def __init__(self, proto_writer):
        self.proto_writer = proto_writer

    @staticmethod
    def get_queryset():
        return CoachSchema.objects.all()

    def dump(self):
        schema_ids = set()
        for record in self.get_queryset():
            proto = TCoachSchema()
            proto.Id = record.id
            proto.Name = record.name
            proto.Places = record.all_places
            proto.Details = record.details
            proto.Svg = record.svg_schema
            proto.TwoStorey = record.two_storey
            self.proto_writer.write(proto)
            schema_ids.add(record.id)
        return schema_ids
