from travel.rasp.trains.train_admin.dumper.proto_writer import FileProtoWriter
from travel.rasp.trains.train_admin.dumper.dumpers.coach_binding_dumper import CoachBindingDumper
from travel.rasp.trains.train_admin.dumper.dumpers.coach_schema_dumper import CoachSchemaDumper
from travel.rasp.trains.train_admin.dumper.dumpers.facility_dumper import FacilityDumper
from travel.rasp.trains.train_admin.dumper.dumpers.service_class_dumper import ServiceClassDumper
from travel.rasp.trains.train_admin.dumper.dumpers.station_express_alias_dumper import StationExpressAliasDumper


class Dumper:
    @staticmethod
    def dump():
        with FileProtoWriter('station_express_alias') as writer:
            StationExpressAliasDumper(writer).dump()
        with FileProtoWriter('coach_schema') as writer:
            schema_ids = CoachSchemaDumper(writer).dump()
        with FileProtoWriter('coach_binding') as writer:
            CoachBindingDumper(writer).dump(schema_ids)
        with FileProtoWriter('service_class') as writer:
            ServiceClassDumper(writer).dump()
        with FileProtoWriter('facility') as writer:
            FacilityDumper(writer).dump()
