from travel.proto.dicts.trains.facility_pb2 import TFacility

from travel.rasp.trains.train_admin.train_admin.models import Facility


class FacilityDumper:
    def __init__(self, proto_writer):
        self.proto_writer = proto_writer

    @staticmethod
    def get_queryset():
        return Facility.objects.all()

    def dump(self):
        for record in self.get_queryset():
            proto = TFacility()
            proto.Id = record.id
            proto.Name = record.name
            proto.Code = record.code
            proto.ImCode = record.im_code
            proto.Title = record.title
            proto.ForPlace = record.for_place
            self.proto_writer.write(proto)
