import datetime

from travel.proto.dicts.trains.coach_type_pb2 import TCoachType
from travel.proto.dicts.trains.service_class_pb2 import TServiceClass

from travel.rasp.trains.train_admin.train_admin.models import ServiceClass


class ServiceClassDumper:
    def __init__(self, proto_writer):
        self.proto_writer = proto_writer

    @staticmethod
    def get_queryset():
        return ServiceClass.objects.all()

    def dump(self):
        for record in self.get_queryset():
            proto = TServiceClass()

            proto.Name = record.name
            proto.Code = record.code
            proto.Title = record.title
            proto.Description = record.description
            if record.coach_category:
                proto.CoachCategory = TCoachType.EType.Value(record.coach_category.upper())
            proto.CoachOwner = record.coach_owner
            proto.BrandTitle = record.brand_title
            proto.TrainNumber = record.train_number
            if record.is_firm_coach is not None:
                proto.IsFirmCoach.value = record.is_firm_coach
            if record.two_storey is not None:
                proto.TwoStorey.value = record.two_storey
            start_date = record.start_date
            if start_date:
                start_date = datetime.datetime(start_date.year, start_date.month, start_date.day)
                proto.StartDate.FromDatetime(start_date)
            end_date = record.end_date
            if end_date:
                end_date = datetime.datetime(end_date.year, end_date.month, end_date.day)
                proto.EndDate.FromDatetime(end_date)

            self.proto_writer.write(proto)
