import struct

UINT32 = struct.Struct('<I')


class FileProtoWriter:
    def __init__(self, filename):
        self.filename = filename + '.bin'

    def __enter__(self):
        self.file = open(self.filename, 'wb')
        return self

    def write(self, proto):
        bin_proto = proto.SerializeToString()
        size = UINT32.pack(len(bin_proto))
        self.file.write(size)
        self.file.write(bin_proto)

    def __exit__(self, exc_type, exc_val, exc_tb):
        self.file.close()
