"""
Django settings for train_admin project.

Generated by 'django-admin startproject' using Django 2.2.9.

For more information on this file, see
https://docs.djangoproject.com/en/2.2/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/2.2/ref/settings/
"""

import os
import json

from django_yauth.settings import *  # noqa
from library.python.django.utils import patch_settings_for_arcadia
from travel.library.python.rasp_vault.api import get_secret

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.abspath(__file__))


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/2.2/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = '1pszp$4=-i3c4__corqlz2eu1(gz!802gz*-lb50!c*+ab538-'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = bool(os.getenv('TRAIN_ADMIN_DEBUG', False))

ALLOWED_HOSTS = ['*']


# Application definition

INSTALLED_APPS = [
    'travel.rasp.trains.train_admin.train_admin.apps.TrainAdminAppConfig',
    'django_yauth',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

SILENCED_SYSTEM_CHECKS = ['admin.E408']

ROOT_URLCONF = 'travel.rasp.trains.train_admin.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'travel.rasp.trains.train_admin.wsgi.wsgi.application'


# Database
# https://docs.djangoproject.com/en/2.2/ref/settings/#databases
DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.postgresql',
        'NAME': os.getenv('TRAIN_ADMIN_DB_NAME', 'testing'),
        'HOST': os.getenv('TRAIN_ADMIN_DB_HOST', 'localhost'),
        'USER': os.getenv('TRAIN_ADMIN_DB_USER', ''),
        'PASSWORD': os.getenv('TRAIN_ADMIN_DB_PASSWORD', ''),
    }
}

# Password validation
# https://docs.djangoproject.com/en/2.2/ref/settings/#auth-password-validators
AUTH_PASSWORD_VALIDATORS = []


# Internationalization
# https://docs.djangoproject.com/en/2.2/topics/i18n/

LANGUAGE_CODE = 'ru-ru'

TIME_ZONE = 'Europe/Moscow'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/2.2/howto/static-files/

STATIC_URL = '/static/'
STATIC_ROOT = os.path.join(BASE_DIR, 'static')

YAUTH_TYPE = 'intranet'
YAUTH_USE_NATIVE_USER = True
YAUTH_USE_SITES = False

envs = {
    'testing': {
        'db_name': 'pgaas__testing__rasp_train_admin',
        'db_host': 'man-w54kaxtaxy5c3cud.db.yandex.net,sas-0adaja7re8c8xswf.db.yandex.net,vla-7elyxbpyi4lcsqef.db.yandex.net',
        'secret': 'rasp-train_admin-testing'
    },
    'production': {
        'db_name': 'pgaas__production__rasp_train_admin',
        'db_host': 'man-eqp7d6tuo6zv6wom.db.yandex.net,sas-q84rf285h9q2y5it.db.yandex.net,vla-dvlxyl47x3539mpw.db.yandex.net',
        'secret': 'rasp-train_admin-production'
    }
}
YENV_TYPE = os.environ['YENV_TYPE']
if YENV_TYPE in envs:
    from django_idm_api.settings import IDM_API_TVM_DEFAULTS

    IDM_INSTANCE = 'production'
    IDM_URL_PREFIX = 'idm/'
    IDM_TVM_CLIENT_ID = 2001600
    IDM_API_TVM_DEFAULTS['allowed_clients'] = (IDM_TVM_CLIENT_ID,)

    INSTALLED_APPS = ['django_idm_api'] + INSTALLED_APPS

    secrets_from_env = os.getenv('SANDBOX_SECRETS_FROM_ENV')
    secret = json.loads(secrets_from_env) if secrets_from_env else get_secret(envs[YENV_TYPE]['secret'])
    DATABASES = {
        'default': {
            'ENGINE': 'django.db.backends.postgresql',
            'NAME': envs[YENV_TYPE]['db_name'],
            'USER': 'rasp',
            'PASSWORD': secret['DBAAS_POSTGRES_TRAIN_DB_PASSWORD'],
            'HOST': envs[YENV_TYPE]['db_host'],
            'PORT': 6432,
            'DISABLE_SERVER_SIDE_CURSORS': True,
            'OPTIONS': {
                'sslmode': 'verify-full',
                'target_session_attrs': 'read-write',
            }
        }
    }
    IDM_API_TVM_SETTINGS = {
        'client_id': secret['TVM_ID'],
        'secret': secret['TVM_SECRET'],
    }
    MIDDLEWARE.remove('django.contrib.auth.middleware.AuthenticationMiddleware')
    MIDDLEWARE += ['django_idm_api.middleware.TVMMiddleware', 'django_yauth.middleware.YandexAuthMiddleware']

patch_settings_for_arcadia()
