from django.contrib import admin
from django.contrib.admin import widgets
from django.db import models

from .models import StationExpressAlias, CoachSchema, CoachBinding, ServiceClass, Facility
from .helpers.csv_export import RaspExportModelAdmin


@admin.register(StationExpressAlias)
class StationExpressAliasAdmin(RaspExportModelAdmin):
    pass


class CoachBindingInline(admin.TabularInline):
    model = CoachBinding
    fields = (
        'klass', 'coach_subtype_code', 'road', 'service_class', 'international_service_class', 'start_settlement_id',
        'end_settlement_id', 'train_number', 'coach_number', 'priority', 'schema', 'direction_confirmed'
    )
    formfield_overrides = {
        models.CharField: {'widget': widgets.AdminTextInputWidget(attrs={'style': 'width: 11em;'})},
        models.TextField: {'widget': widgets.AdminTextareaWidget(attrs={'style': 'width: 11em; height: 1.5em;'})},
    }
    extra = 1


@admin.register(CoachSchema)
class CoachSchemaAdmin(RaspExportModelAdmin):
    list_display = ('name',)
    inlines = [
        CoachBindingInline,
    ]
    fieldsets = (
        ('Profile field', {'fields': ('name', 'two_storey', 'all_places')}),
        ('Признаки мест', {'fields': ('details',)}),
        ('Новый svg', {'fields': ('svg_schema',)}),
    )


@admin.register(CoachBinding)
class CoachBindingAdmin(RaspExportModelAdmin):
    list_display = (
        'klass', 'coach_subtype_code', 'road', 'service_class', 'international_service_class', 'start_settlement_id',
        'end_settlement_id', 'train_number', 'coach_number', 'priority', 'schema', 'direction_confirmed'
    )


@admin.register(ServiceClass)
class ServiceClassAdmin(RaspExportModelAdmin):
    list_display = ('code', 'name', 'title', 'description')
    search_fields = ('code', 'name', 'title', 'description')


@admin.register(Facility)
class FacilityAdmin(RaspExportModelAdmin):
    list_display = ('code', 'im_code', 'for_place', 'name', 'order', 'title')
    search_fields = ('code', 'im_code', 'name', 'title')
