# Generated by Django 2.2.10 on 2020-03-18 20:01

from django.db import migrations, models
from travel.rasp.trains.train_admin.train_admin.utils import TrimmedCharField, RegExpCharField, RegExpTextField


class Migration(migrations.Migration):

    dependencies = [
        ('train_admin', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='CoachSchema',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', TrimmedCharField(default=None, max_length=100, verbose_name='Название')),
                ('all_places', models.TextField(blank=True, default='', verbose_name='Все места (через запятую)')),
                ('details', models.TextField(blank=True, default='', verbose_name='Дополнительная информация о вагоне и местах')),
                ('svg_schema', models.TextField(blank=True, default='', verbose_name='Размеченная схема вагона (содержание svg файла)')),
                ('two_storey', models.BooleanField(default=False, verbose_name='Двухэтажный вагон')),
            ],
            options={
                'verbose_name': 'схема вагонов',
                'verbose_name_plural': 'схемы вагонов',
            },
        ),
        migrations.CreateModel(
            name='CoachBinding',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('klass', models.CharField(choices=[('compartment', 'купе'), ('suite', 'СВ/люкс'), ('sitting', 'сидячий'), ('platzkarte', 'плацкарт'), ('soft', 'мягкий'), ('common', 'общий')],
                                           blank=True, default='', max_length=100, verbose_name='Категория вагона')),
                ('service_class', RegExpCharField(blank=True, default='', max_length=100, verbose_name='Класс обслуживания')),
                ('international_service_class', RegExpCharField(blank=True, default='', max_length=100, verbose_name='Международный класс обслуживания')),
                ('start_settlement_id', models.IntegerField(blank=True, null=True, verbose_name='Город отправления поезда')),
                ('end_settlement_id', models.IntegerField(blank=True, null=True, verbose_name='Город прибытия поезда')),
                ('coach_subtype_code', TrimmedCharField(blank=True, default='', help_text='Можно указать несколько через запятую', max_length=100, verbose_name='Подтип вагона')),
                ('road', RegExpCharField(blank=True, default='', help_text='или государство принадлежности', max_length=255, verbose_name='Дорога принадлежности вагона')),
                ('train_number', RegExpTextField(blank=True, default='', verbose_name='Номер поезда')),
                ('coach_number', RegExpCharField(blank=True, default='', max_length=255, verbose_name='Номер вагона')),
                ('priority', models.IntegerField(default=10, verbose_name='Приоритет')),
                ('direction_confirmed', models.BooleanField(default=False, verbose_name='Направление движения подтверждено')),
                ('schema', models.ForeignKey(on_delete=models.CASCADE, to='train_admin.CoachSchema', verbose_name='схема')),
            ],
            options={
                'verbose_name': 'привязка схемы вагона',
                'verbose_name_plural': 'привязки схем вагонов',
            },
        ),
    ]
