# Generated by Django 2.2.11 on 2020-04-14 22:46

from django.db import migrations, models
from travel.rasp.trains.train_admin.train_admin.utils import CodeCharField, TrimmedCharField, RegExpCharField


class Migration(migrations.Migration):

    dependencies = [
        ('train_admin', '0002_coachbinding_coachschema'),
    ]

    operations = [
        migrations.CreateModel(
            name='ServiceClass',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, default='', max_length=1024, verbose_name='Название для админки')),
                ('code', CodeCharField(help_text='Можно указать несколько через запятую', max_length=100, verbose_name='Коды классов обслуживания')),
                ('title', TrimmedCharField(max_length=100, verbose_name='Название для отображения (короткое)')),
                ('description', models.TextField(blank=True, default='', verbose_name='Описание класса обслуживания для отображения')),
                ('coach_category', models.CharField(choices=[('compartment', 'купе'), ('suite', 'СВ/люкс'), ('sitting', 'сидячий'), ('platzkarte', 'плацкарт'), ('soft', 'мягкий'),
                                                             ('common', 'общий')],
                                                    blank=True, default='', max_length=20, verbose_name='Категория вагона')),
                ('coach_owner', models.CharField(blank=True, default='', help_text='Можно указать несколько через запятую', max_length=100, verbose_name='Владельцы вагонов')),
                ('brand_title', models.CharField(blank=True, default='', max_length=100, verbose_name='Название бренда')),
                ('is_firm_coach', models.NullBooleanField(default=None, verbose_name='Вагон является фирменным')),
                ('train_number', RegExpCharField(blank=True, default='', help_text='Регулярное выражение', max_length=1024, verbose_name='Номер поезда')),
                ('two_storey', models.NullBooleanField(default=None, verbose_name='Двухэтажный вагон')),
                ('start_date', models.DateField(blank=True, default=None, null=True, verbose_name='Дата начала действия класса обслуживания')),
                ('end_date', models.DateField(blank=True, default=None, null=True, verbose_name='Дата окончания действия класса обслуживания')),
            ],
            options={
                'verbose_name': 'Класс обслуживания',
                'verbose_name_plural': 'Классы обслуживания',
            },
        ),
    ]
