# Generated by Django 2.2.11 on 2020-04-23 12:20

from django.core.validators import RegexValidator
from django.db import migrations, models
from travel.rasp.trains.train_admin.train_admin.utils import CodeCharField, TrimmedCharField


class Migration(migrations.Migration):

    dependencies = [
        ('train_admin', '0003_serviceclass'),
    ]

    operations = [
        migrations.CreateModel(
            name='Facility',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, default='', max_length=1024, verbose_name='Название для админки')),
                ('code', CodeCharField(max_length=100, unique=True, validators=[RegexValidator('[A-Za-z][_A-Za-z0-9]*', 'Код может содержать только латинские буквы, цифры и знак "_"')],
                                       verbose_name='Код')),
                ('im_code', CodeCharField(max_length=100, unique=True, verbose_name='Код в системе IM')),
                ('title', TrimmedCharField(max_length=100, verbose_name='Название для отображения')),
                ('for_place', models.BooleanField(blank=True, default=False, verbose_name='Удобство связанное с местом')),
                ('order', models.IntegerField(default=0, verbose_name='Порядок отображения')),
            ],
            options={
                'verbose_name': 'Удобство',
                'verbose_name_plural': 'Удобства',
            },
        ),
    ]
