from django.http import HttpResponse
from django.shortcuts import get_object_or_404

from .models import CoachSchema

EMPTY_SVG = """<svg width="1" height="1" viewBox="0 0 1 1" fill="none" xmlns="http://www.w3.org/2000/svg"></svg>"""


def coach_schema_svg(request, coach_schema_id):
    svg = get_object_or_404(CoachSchema, id=coach_schema_id).svg_schema or EMPTY_SVG
    return HttpResponse(svg, content_type='image/svg+xml')
