from django.conf import settings
from django.contrib import admin
from django.contrib.staticfiles.urls import staticfiles_urlpatterns
from django.urls import include, path

from .train_admin.views import coach_schema_svg

urlpatterns = [
    path('admin/', admin.site.urls),
    path('admin/coach-schema-svg/<int:coach_schema_id>/', coach_schema_svg, name='coach-schema-svg')
] + staticfiles_urlpatterns()

if 'django-idm-api' in settings.INSTALLED_APPS:
    urlpatterns += [
        path('idm/', include('django_idm_api.urls')),
    ]
