PY3_LIBRARY(train_admin)

OWNER(g:trains-back)

PEERDIR(
    contrib/python/django/django-2.2
    contrib/python/gunicorn
    contrib/python/psycopg2

    library/python/django
    library/python/django-idm-api
    library/python/python-django-yauth
    library/python/gunicorn

    travel/library/python/rasp_vault
    travel/proto/dicts/trains
)

PY_SRCS(
    dumper/dumpers/__init__.py
    dumper/dumpers/coach_binding_dumper.py
    dumper/dumpers/coach_schema_dumper.py
    dumper/dumpers/dumper.py
    dumper/dumpers/facility_dumper.py
    dumper/dumpers/service_class_dumper.py
    dumper/dumpers/station_express_alias_dumper.py

    dumper/__init__.py
    dumper/main.py
    dumper/proto_writer.py

    train_admin/helpers/csv_export.py

    train_admin/migrations/__init__.py
    train_admin/migrations/0001_initial.py
    train_admin/migrations/0002_coachbinding_coachschema.py
    train_admin/migrations/0003_serviceclass.py
    train_admin/migrations/0004_facility.py

    train_admin/__init__.py
    train_admin/admin.py
    train_admin/apps.py
    train_admin/models.py
    train_admin/utils.py
    train_admin/views.py

    docker/local_settings.py
    manage/manage.py
    wsgi/wsgi.py

    __init__.py
    gunicorn_conf.py
    settings.py
    urls.py
)

RESOURCE_FILES( PREFIX travel/rasp/trains/train_admin/
    train_admin/fixtures/coach_schema_coach_binding.json
    train_admin/fixtures/facility.json
    train_admin/fixtures/service_class.json
    train_admin/fixtures/station_express_alias.json

    train_admin/templates/admin/train_admin/coachschema/change_form.html
)

END()

RECURSE(
    dumper
    manage
    wsgi
)
