# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import codecs
from contextlib import contextmanager
from subprocess import Popen, PIPE, check_output


@contextmanager
def check_output_stream(*popen_args):
    process = Popen(*popen_args, stdout=PIPE)
    out_stream = codecs.getreader('utf8')(process.stdout)
    try:
        yield out_stream
    finally:
        process.stdout.close()
        if process.poll() is None:
            try:
                process.terminate()
            except Exception:
                pass
        elif process.poll() != 0:
            raise Exception('Command Error {} {!r}'.format(process.poll(), popen_args))


def check_output_stripped(args, **kwargs):
    stdout = codecs.decode(check_output(args, **kwargs), 'utf8')
    return stdout.rstrip('\n')
