package application

import (
	"context"

	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/travel/rasp/wizards/go/wizard_proxy_api/internal/storage"
)

type Config struct {
	// Вернуть город, если он один и нет неавтобусных станций, не принадлежащих данному городу
	ReturnSingleCityIfOneCityAndNoOutsideNonBusStations bool
	SearchPointLimit                                    int
}

type Application struct {
	Cfg     *Config
	Storage *storage.Storage
	Logger  *zap.Logger
}

func NewApplication(ctx context.Context, cfg *Config, s *storage.Storage, logger *zap.Logger) (*Application, error) {
	application := &Application{
		Cfg:     cfg,
		Storage: s,
		Logger:  logger,
	}
	return application, nil
}
