package internal

import (
	"net/http"
	"sync"
	"time"
)

type Response struct {
	Resp http.Response
	Err  error
}

func FetchUrls(urls []string, timeout time.Duration) map[string]*Response {
	// TODO: single client
	client := &http.Client{
		Timeout: timeout,
	}

	var wg sync.WaitGroup
	var m sync.Mutex
	result := make(map[string]*Response)

	for _, url := range urls {
		wg.Add(1)
		go func(url string) {
			defer wg.Done()

			res, err := client.Get(url)
			if err != nil {
				result[url] = &Response{http.Response{}, err}
				return
			}

			m.Lock()
			result[url] = &Response{*res, err}
			m.Unlock()
		}(url)
	}
	wg.Wait()

	return result
}
