package geomodel

import (
	"encoding/json"
	"errors"
	"fmt"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type Country struct {
	rasp.TCountry
}

func (country *Country) IsHidden() bool {
	return false
}

func (country *Country) GetID() int {
	return int(country.TCountry.Id)
}

func (country *Country) GetMajorityByteValue() byte { // TODO: dummy
	return 0
}

func (country *Country) GetType() PointType {
	return ECountry
}

func (country *Country) PopularTitle() string { // TODO: check logic
	return country.TitleDefault
}

func (country *Country) GetRegionID() (int, error) {
	return 0, errors.New("non applicable")
}

func (country *Country) ReprPoint() PointRepr {
	return PointRepr{
		Key:   country.GetId(),
		Title: country.PopularTitle(),
	}
}

func (country *Country) DumpPoint() ([]byte, error) {
	dump, err := json.Marshal(PointRepr{
		Key:   country.GetId(),
		Title: country.PopularTitle(),
	})
	if err != nil {
		return nil, fmt.Errorf("cannot dump point: %w", err)
	}
	return dump, nil
}

func (country *Country) GetTitle() string {
	return country.TitleDefault // TODO: which title? check point.title in common/geo_models/country
}

func (country *Country) GetTypeChoicesSet() (map[TransportType]bool, error) {
	return nil, errors.New("non applicable")
}
