package geomodel

import (
	"errors"
	"strconv"
)

type PointType byte

const ( // TODO: check order
	EStation PointType = iota
	ESettlement
	ERegion
	ECountry
)

func (t PointType) String() string {
	return [...]string{"Station", "Settlement", "Region", "Country"}[t]
}

func ParseKey(key string) (PointType, int, error) {
	if len(key) < 2 {
		return 0, 0, errors.New("point key is invalid")
	}

	modelKey := key[0]
	numKey, err := strconv.Atoi(key[1:])
	if err != nil {
		return 0, 0, errors.New("point key has invalid number part")
	}

	var model PointType
	switch modelKey {
	case 'c':
		model = ESettlement
	case 's':
		model = EStation
	case 'r':
		model = ERegion
	case 'l':
		model = ECountry
	default:
		return 0, 0, errors.New("point key has invalid model type")
	}
	return model, numKey, nil
}
