package geomodel

import (
	"encoding/json"
	"fmt"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type Settlement struct {
	*rasp.TSettlement
}

func (settlement *Settlement) IsHidden() bool {
	return settlement.TSettlement.IsHidden
}

func (settlement *Settlement) GetID() int {
	return int(settlement.TSettlement.Id)
}

func (settlement *Settlement) GetMajorityByteValue() byte { // TODO: dummy
	return 0
}

func (settlement *Settlement) GetType() PointType {
	return ESettlement
}

func (settlement *Settlement) PopularTitle() string { // TODO: dummy
	return "Москва"
}

func (settlement *Settlement) GetRegionID() (int, error) {
	return int(settlement.TSettlement.RegionId), nil
}

func (settlement *Settlement) ReprPoint() PointRepr {
	return PointRepr{
		Key:   settlement.Id,
		Title: settlement.PopularTitle(),
	}
}

func (settlement *Settlement) DumpPoint() ([]byte, error) {
	dump, err := json.Marshal(PointRepr{
		Key:   settlement.Id,
		Title: settlement.PopularTitle(),
	})
	if err != nil {
		return nil, fmt.Errorf("cannot dump point: %w", err)
	}
	return dump, nil
}

func (settlement *Settlement) GetTitle() string {
	return settlement.TitleDefault // TODO: which title? check point.title in common/geo_models/settlement
}

func (settlement *Settlement) GetTypeChoicesSet() (map[TransportType]bool, error) {
	// TODO need to add type_choices field
	typeSet := map[TransportType]bool{}
	return typeSet, nil
}
