package geomodel

import (
	"encoding/json"
	"fmt"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type Station struct {
	*rasp.TStation
}

func (station *Station) IsHidden() bool {
	return station.TStation.IsHidden
}

func (station *Station) GetID() int {
	return int(station.TStation.Id)
}

func (station *Station) GetMajorityByteValue() byte { // TODO: dummy
	return 0
}

func (station *Station) GetMajorityID() StationMajority { // TODO: dummy
	return StationMajorityMainInCityID
}

func (station *Station) GetType() PointType {
	return EStation
}

func (station *Station) PopularTitle() string { // TODO: check logic
	return station.TStation.PopularTitleDefault
}

func (station *Station) GetRegionID() (int, error) {
	return int(station.TStation.RegionId), nil
}

func (station *Station) ReprPoint() PointRepr {
	return PointRepr{
		Key:   station.Id,
		Title: station.PopularTitle(),
	}
}

func (station *Station) DumpPoint() ([]byte, error) {
	dump, err := json.Marshal(PointRepr{
		Key:   station.Id,
		Title: station.PopularTitle(),
	})
	if err != nil {
		return nil, fmt.Errorf("cannot dump point: %w", err)
	}
	return dump, nil
}

func (station *Station) GetTitle() string {
	return station.TitleDefault // TODO: which title? check point.title in common/geo_models/station
}

func (station *Station) GetSettlementID() (int, error) {
	return int(station.TStation.SettlementId), nil
}

func (station *Station) GetTransportType() TransportType {
	_ = station.TStation.TransportType
	return ETransportNone // TODO: make correct translation
}

func (station *Station) GetTypeChoicesSet() (map[TransportType]bool, error) {
	// TODO need to add type_choices field
	typeSet := map[TransportType]bool{}
	return typeSet, nil
}

func (station *Station) HasAeroexpress() bool { // TODO dummy
	return true
}
