package geosearch

import (
	"a.yandex-team.ru/travel/rasp/wizards/go/wizard_proxy_api/internal/geomodel"
)

type PointList struct {
	MainPoint      geomodel.Point
	Variants       []geomodel.Point
	Term           string
	IsFinal        bool // вариант финальный и уточнения не нужны
	IsExactVariant bool // Признак, что передали идентификатор точки
	DontRearrange  bool
	AllowReduce    bool
}

func NewPointListWithVariants(point geomodel.Point, variants []geomodel.Point, title string, exactVariat bool) (*PointList, error) {
	return &PointList{
		MainPoint:      point,
		Variants:       []geomodel.Point{point},
		Term:           title,
		IsExactVariant: exactVariat,
	}, nil
}

func NewPointList(point geomodel.Point, exactVariat bool) (*PointList, error) {
	return NewPointListWithVariants(point, nil, "", exactVariat)
}

func (pl *PointList) HasVariants() bool {
	return len(pl.Variants) != 0
}

// Если город не выбран, то берем первый вариант
func (pl *PointList) choozeFirstIfNotChoosed() {
	if pl.MainPoint == nil {
		if len(pl.Variants) > 0 {
			pl.MainPoint = pl.Variants[0]
		}
		if len(pl.Variants) > 1 {
			pl.AllowReduce = false
		}
	}
}
