package logging

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
)

type LogConfig struct {
	LogPath string `config:"WPA_LOG_PATH,required"`
	Level   string `config:"WPA_LOG_LEVEL"`
}

var DefaultLogConfig = LogConfig{
	LogPath: "/var/log/app/logs.log",
	Level:   "info",
}

func New(config LogConfig) (*zap.Logger, error) {
	level, err := log.ParseLevel(config.Level)
	if err != nil {
		return nil, fmt.Errorf("bad log level format: %w", err)
	}

	logger, err := zap.NewQloudLogger(level)
	if err != nil {
		return nil, fmt.Errorf("cannot create logger: %w", err)
	}

	return logger, nil
}
